init_elements()
z.A = point(3.8, 2.5)
z.B = point(0, 0)
z.C = point(6, 0.5)
T.ABC = triangle(z.A, z.B, z.C)
z.I = T.ABC.incenter
z.O = T.ABC.circumcenter
z.Y = T.ABC:kimberling(56)
local r = T.ABC.inradius
local R = tkz.length(z.O, z.A)
local rho = (r * R) / (R - r)
local C = circle(through(z.Y, rho))
z.T = C.through
local bisectors = {
  {z.A, z.I, "wa", T.ABC.ab},
  {z.B, z.I, "wb", T.ABC.bc},
  {z.C, z.I, "wc", T.ABC.ca}
}
for _, bisector in ipairs(bisectors) do
  local origin, incenter, name, side = unpack(bisector)
  local L = line(origin, incenter)
  local x, y = intersection(C, L)
  local d = side:distance(x)
  if math.abs(d - C.radius) < tkz.epsilon then
    z[name] = x
  else
    z[name] = y
  end
end
